<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form URL Shortener</title>
    <style>
        form {
            display: flex;
            flex-direction: column;
            width: 300px; /* Sesuaikan lebar sesuai kebutuhan */
            margin: 0 auto; /* Untuk centering form di halaman */
        }

        input, button {
            margin-bottom: 10px; /* Jarak antara elemen */
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        button {
            background-color: #4CAF50;
            color: white;
            cursor: pointer;
            border: none;
        }

        button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

    <form method="post" action="">
        <input type="url" name="original_url" placeholder="Input URL ASLI" required>
        <input type="text" name="custom_slug" placeholder="Input Slug atau Kode di Belakang /" required>
        <input type="text" name="og_title" placeholder="Input Title" required>
        <input type="text" name="og_description" placeholder="Input Deskripsi" required>
        <input type="url" name="og_image_url" placeholder="Masukkan URL gambar" required>
        <button type="submit">Create</button>
    </form>

</body>
</html>

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $original_url = $_POST['original_url'];
    $custom_slug = $_POST['custom_slug'];
    $og_title = $_POST['og_title'];
    $og_description = $_POST['og_description'];
    $og_image_url = $_POST['og_image_url'];

    // Define the root directory for file operations (local path)
    $root_directory = 'C:/laragon/www'; // Change this to your actual public_html path

    // Define the root domain URL
    $root_domain = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];

    // Define paths using the root directory
    $base_folder_path = "$root_directory/$custom_slug";
    $gogo_folder_path = "$base_folder_path/gogo";
    $wait_folder_path = "$base_folder_path/wait";

    // Create folders if they don't exist
    if (!is_dir($base_folder_path)) {
        mkdir($base_folder_path, 0777, true);
    }
    if (!is_dir($gogo_folder_path)) {
        mkdir($gogo_folder_path, 0777, true);
    }
    if (!is_dir($wait_folder_path)) {
        mkdir($wait_folder_path, 0777, true);
    }

    // Master template (for the main index.php in custom_slug)
    $master_template = file_get_contents("$root_directory/master.php");
    $master_template = str_replace('$og_title', $og_title, $master_template);
    $master_template = str_replace('$og_description', $og_description, $master_template);
    $master_template = str_replace('$custom_slug', $custom_slug, $master_template);
    $master_template = str_replace('$original_url', $original_url, $master_template);
    $master_template = str_replace('$og_image_url', $og_image_url, $master_template);

    // Save the master template in the base folder as index.php
    file_put_contents("$base_folder_path/index.php", $master_template);

    // Gogo template (from external gogo.php)
    $gogo_template = file_get_contents("$root_directory/gogo.php");
    $gogo_template = str_replace('$og_title', $og_title, $gogo_template);
    $gogo_template = str_replace('$og_description', $og_description, $gogo_template);
    $gogo_template = str_replace('$custom_slug', $custom_slug, $gogo_template);
    $gogo_template = str_replace('$original_url', $original_url, $gogo_template);
    $gogo_template = str_replace('$og_image_url', $og_image_url, $gogo_template);

    // Save the gogo template in gogo/index.php
    file_put_contents("$gogo_folder_path/index.php", $gogo_template);

    // Wait template (from external wait.php)
    $wait_template = file_get_contents("$root_directory/wait.php");
    $wait_template = str_replace('$og_title', $og_title, $wait_template);
    $wait_template = str_replace('$og_description', $og_description, $wait_template);
    $wait_template = str_replace('$custom_slug', $custom_slug, $wait_template);
    $wait_template = str_replace('$original_url', $original_url, $wait_template);
    $wait_template = str_replace('$og_image_url', $og_image_url, $wait_template);

    // Save the wait template in wait/index.php
    file_put_contents("$wait_folder_path/index.php", $wait_template);

    // Ads.php template (from external ads.php)
    $ads_template = file_get_contents("$root_directory/ads.php");
    $ads_template = str_replace('$original_url', $original_url, $ads_template);

    // Save the ads.php file in the wait folder
    file_put_contents("$wait_folder_path/ads.php", $ads_template);

    // Define the base URL for links
    $base_url = "$root_domain/$custom_slug";

    // Output the shortened URL
    echo "URL shortened successfully: <a href=\"$base_url\">$base_url</a>";
}
?>
